/*
Bibliothques tires du forum developpez.com
*/

#ifndef DEVELOPPEZ
#define DEVELOPPEZ

/*Fonction GetClock code par souviron34 de c.developpez.com*/
#include <time.h>
#include <sys/time.h>

#include <string.h>

int fpurge(FILE *in);
int fclean(char *s, FILE *in);
/*Fonction GetClock code par souviron34 de c.developpez.com*/
double GetClock (void);

int fpurge(FILE *in)
{
	int c;
	while((c=fgetc(in)) != '\n' && c != EOF) {}
	return (c==EOF ? -1 : 0);
}

int fclean(char *s, FILE *in)
{
	int res = 0;
	char *pLF = strchr(s, '\n');
	if(pLF != NULL)
	{
		/* Si LF trouv, le supprime du buffer */
		*pLF = '\0';
	}
	else
	{
		/* LF non-trouv: il est encore dans le flux */
		res = fpurge(in);
	}
	return res;
}

/*Fonction GetClock code par souviron34 de c.developpez.com*/
double GetClock ( void )
{
  double d=-1.0 ;
#ifdef WIN32 //win
    #ifdef WIN32 //win
       struct timeval tval ;
       struct timezone *tz=(struct timezone *)NULL ;
       timerclear(&tval);
       if ( gettimeofday(&tval, tz) )
          fprintf (stderr, "\nCLOCK ERROR !!!\n");
       else
       {
          d = ((double)(tval.tv_usec)/1000000.0) ;
          d = (double) tval.tv_sec + d ;
       }
    #else   //linux
       struct timespec cur_time, res ;
       if (clock_gettime(CLOCK_REALTIME, &cur_time))
          fprintf (stderr, "\nCLOCK ERROR !!!\n");
       else
       {
          d = ((double)(cur_time.tv_nsec)/1000.0) / 1000000.0 ;
          d = (double) cur_time.tv_sec + d ;
       }
    #endif
#else   //linux
   struct timeval tval ;
   struct timezone *tz=(struct timezone *)NULL ;
   timerclear(&tval);
   if ( gettimeofday(&tval, tz) )
      fprintf (stderr, "\nCLOCK ERROR !!!\n");
   else
   {
      d = ((double)(tval.tv_usec)/1000000.0) ;
      d = (double) tval.tv_sec + d ;
   }
#endif
   return d ;
}

#endif
